/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.strawgolem.storage;

import com.t2pellet.strawgolem.StrawgolemCommon;
import com.t2pellet.strawgolem.crop.CropHandler;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class StrawgolemSaveData {
    private static final int VERSION = 1;
    private static final int TAG_COMPOUND = 10;
    private final File worldDataDir;
    private static final String POS = "pos";
    private static final String VERSION_KEY = "version";

    public StrawgolemSaveData(MinecraftServer server) {
        this.worldDataDir = new File(server.method_27050(class_5218.field_24188) + "strawgolem");
        if (!this.worldDataDir.exists()) {
            this.worldDataDir.mkdirs();
        }
    }

    public void loadData(MinecraftServer server) throws IOException {
        StrawgolemCommon.LOG.info("Loading strawgolem save data");
        for (class_3218 world : server.method_3738()) {
            class_2487 worldTag;
            File saveFile = new File(this.worldDataDir, this.getFileName((class_1937)world));
            if (!saveFile.exists() || !saveFile.isFile() || !(worldTag = class_2507.method_30613((File)saveFile)).method_10545(VERSION_KEY) || worldTag.method_10550(VERSION_KEY) != 1) continue;
            class_2499 positionsTag = worldTag.method_10554(POS, 10);
            positionsTag.forEach(tag -> {
                class_2338 pos = class_2512.method_10691((class_2487)((class_2487)tag));
                CropHandler.INSTANCE.addCrop((class_1937)world, pos);
            });
        }
    }

    public void saveData(MinecraftServer server) throws IOException {
        StrawgolemCommon.LOG.info("Saving strawgolem save data");
        class_2487 worldTag = new class_2487();
        class_2499 positionsTag = new class_2499();
        for (class_3218 world : server.method_3738()) {
            Iterator<class_2338> cropIterator = CropHandler.INSTANCE.getCrops((class_1937)world);
            while (cropIterator.hasNext()) {
                class_2338 pos = cropIterator.next();
                positionsTag.add((Object)class_2512.method_10692((class_2338)pos));
            }
            worldTag.method_10566(POS, (class_2520)positionsTag);
            worldTag.method_10569(VERSION_KEY, 1);
            File file = new File(this.worldDataDir, this.getFileName((class_1937)world));
            class_2507.method_30614((class_2487)worldTag, (File)file);
        }
    }

    private String getFileName(class_1937 world) {
        class_2960 id = world.method_27983().method_29177();
        return id.method_12836() + "-" + id.method_12832() + ".dat";
    }
}

